#! /usr/bin/env python
from __future__ import print_function
import sys

# If your pyfplo is not found you could also
# explicitly specify the pyfplo version path:
#sys.path.insert(0,"/home/magru/FPLO/FPLO22.00-62/PYTHON/doc");

import numpy as np
import pyfplo.slabify as sla


print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(sla.version,sla.__file__))
# protect against wrong version
#if fedit.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')


# ===================================================================
# 
# ===================================================================

def work():


    hamdata='../+hamdata'
    
    s=sla.Slabify()


    s.object='slab'
    s.enlarge=[ [1,1,0],[-1,1,0],[0,0,1]]
    s.anchor=-0.001
    s.numberoflayers=10
    s.cutatoms=[2,4,20]
    s.printStructureSettings()

    s.prepare(hamdata)
    
    
    # all orbitals up to 10 length units at the upper surface
    upper=s.orbitalNamesByDepth(-1,10)
    # all orbitals up to 10 length units at the lower surface
    lower=s.orbitalNamesByDepth(10,-1)
    # a nice python trick to get the rest list
    rest=list(set(s.orbitalNames())-set(upper)-set(lower))
    
    
    wds=sla.WeightDefinitions()
    wds.add('bulk').addLabels(rest)
    wds.add('lower').addLabels(lower)
    wds.add('upper').addLabels(upper)


    fso=sla.FermiSurfaceOptions()
    fso.setMesh(200,[-0.5,0.5],200,[-0.5,0.5])
    fso.setPlane([1,0,0],[0,1,0],[0,0,1])
    fso.fermienergy=0
    s.calculateFermiSurfaceCuts(fso,wds=wds,suffix='E=0',
                                forcerecalculation=True);

    fso.fermienergy=-1.
    s.calculateFermiSurfaceCuts(fso,wds=wds,suffix='E=-1.',
                                forcerecalculation=False);
    



# ===================================================================
# 
# ===================================================================


if __name__ == '__main__':

    work()

