#! /usr/bin/env python

from __future__ import print_function
import sys

# If your pyfplo is not found you could also
# explicitly specify the pyfplo version path:
#sys.path.insert(0,"/home/magru/FPLO/FPLO22.00-62/PYTHON/doc");

import numpy as np
import pyfplo.slabify as sla


print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(sla.version,sla.__file__))
# protect against wrong version
#if fedit.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')



# ===================================================================
# 
# ===================================================================

def work():


    hamdata='..//+hamdata'
    
    s=sla.Slabify()


    s.object='semislab'
    s.anchor=-0.001
    s.numberoflayers=4
    s.printStructureSettings()

    s.prepare(hamdata)
    
    bp=sla.BandPlot()
    bp.points=[
        ['$~G',[0,0,0]],
        ['X',[0.5,0,0]],
        ['M',[0.5,0.5,0]],
        ['$~G',[0,0,0]],
        ]
    bp.ndiv=60
    bp.calculateBandPlotMesh(s.dirname)

    ec=sla.EnergyContour(200,-15,25)
    print( ec)

    bp.on()

    # penetration one block (primary layer)
    s.calculateEDC(bp,ec,penetrationdepth=-1,suffix='_1block')

    # penetration 10 blocks (primary layer)
    s.calculateEDC(bp,ec,penetrationdepth=-10,suffix='_10block')

    fso=sla.FermiSurfaceOptions()
    fso.setMesh(200,[-0.5,0.5],200,[-0.5,0.5])
    s.calculateFermiSurfaceSpectralDensity(fso,penetrationdepth=-1,
                                           suffix='_1block')
    s.calculateFermiSurfaceSpectralDensity(fso,penetrationdepth=-10,
                                           suffix='_10block')
                                           





# ===================================================================
# 
# ===================================================================


if __name__ == '__main__':

    work()

