#! /usr/bin/env python
from __future__ import print_function
import pyfplo.wanniertools as wt



# ===================================================================
def main():




    wdc=wt.WanDefCreator(rcutoff=25,wftol=0.001,coeffformat='bin',
                         wfgriddirections=[[1,0,0],[0,1,0],[0,0,1]],
                         wfgridsubdiv=[1,1,1],savespininfo=False,
                         keeprunning=True,opendxinterface=False)
    
    emin=-6
    emax= 4
    delower=1
    deupper=0
    
    wdc.add(wt.MultipleOrbitalWandef('Mo',range(1,4+1),['4db'],
                                     emin=emin,emax=emax,
                                     delower=delower,deupper=deupper))
    wdc.add(wt.MultipleOrbitalWandef('Te',range(5,12+1),['5pb'],
                                     emin=emin,emax=emax,
                                     delower=delower,deupper=deupper))
    
    wdc.writeFile('=.wandef')
  







    return


# ===================================================================
# ===================================================================
# ===================================================================
# ===================================================================
if __name__ == '__main__':
    main()
