#! /usr/bin/env python
from __future__ import print_function
import pyfplo.wanniertools as wt



# ===================================================================
def main():




    wdc=wt.WanDefCreator(rcutoff=25,wftol=0.001,coeffformat='bin',
                         wfgriddirections=[[1,0,0],[0,1,0],[0,0,1]],
                         wfgridsubdiv=[1,1,1],savespininfo=False,
                         keeprunning=True,opendxinterface=False)
    
    emin=-5
    emax= 0
    delower=5
    deupper=5
    
    wdc.add(wt.MultipleOrbitalWandef('Sn',range(1,1+1),['5sb','5pb'],
                                     emin=emin,emax=emax,
                                     delower=delower,deupper=deupper))
    wdc.add(wt.MultipleOrbitalWandef('Te',range(2,2+1),['5sb','5pb'],
                                     emin=emin,emax=emax,
                                     delower=delower,deupper=deupper))
    
    wdc.writeFile('=.wandef')
  







    return


# ===================================================================
# ===================================================================
# ===================================================================
# ===================================================================
if __name__ == '__main__':
    main()
