#! /usr/bin/env python

from __future__ import print_function
import sys

# If your pyfplo is not found you could also
# explicitly specify the pyfplo version path:
#sys.path.insert(0,"/home/magru/FPLO/FPLO22.00-62/PYTHON/doc");

import numpy as np
import pyfplo.slabify as sla


print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(sla.version,sla.__file__))
# protect against wrong version
#if fedit.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')


# ===================================================================
# 
# ===================================================================

def work():

    Ef=0

    hamdata='../../+hamdata'
    
    s=sla.Slabify()
    s.object='3d'
    s.prepare(hamdata)
    

    fso=sla.FermiSurfaceOptions()
    fso.setMesh(50,[0,1],50,[0,1])
    fso.setPlane(xaxis=[1,0,0],yaxis=[0,0,1],origin=[0,0,0])
    fso.fermienergy=Ef

    wds=sla.WeightDefinitions()
    wds.add(name='up').addAtoms(atom='Fe',sites=[1],orbitals=['4s','4p','3d'],spin='up')
    wds.add(name='dn').addAtoms(atom='Fe',sites=[1],orbitals=['4s','4p','3d'],spin='dn')


    s.calculateFermiSurfaceCuts(fso,wds=wds,forcerecalculation=True);


# ===================================================================
# 
# ===================================================================


if __name__ == '__main__':

    work()

