# -- mode: PYTHON --
import numpy as np
killall()
g=G[1]
g.pointsizescale=1.5
ret=g.read('band','slabifyres/+F')[0]
ret.group.useattributes=False
cols=[
    0x00,0xff0000,0xee00,
    0xff,0xff00ff,0xffff,
    0xffdd00,0x808080,0xcc0000,
    0x00cc00,0xcc,0xaa00ff,
    0xaa00aa,0xaaaa00,0xaaaa,    
]
legs=[
    'D-D$_x$.','D-D$_y$.','D-D$_z$.',
    'D-a$_x$.','D-a$_y$.','D-a$_z$.',
    'acurve$_x$.','acurve$_y$.','acurve$_z$.',
    'total$_x$.','total$_y$.','total$_z$.',
    'D-Dsym$_x$.','D-Dsym$_y$.','D-Dsym$_z$.',
]
for i,s in enumerate(ret.sets):
    s.y=np.log10(np.maximum(1e-20,abs(s.y)))
    s.line.color=cols[i]
    s.legend=legs[i]
    if (i%3)!=2: s.off()
    #if i>8: s.off()
#g.yaxis.scaling='log'
g.autoscale()

Legend(1).on()\
  .setText(font=FontStyle(size=12,subscriptscale=0.75,color=0x0),
    linespacing=-0.1)\
  .setSymbol(spacing=0.5,width=1)\
  .setFrame(Frame(active=1,borderspacing=0.4,
      rim=LineStyle(style='solid',width=1,color=0x0,extracolor=True),
      fill=FillStyle(active=True,color=0xffffff,extracolor=True)))\
  .setGeometry(position=(1.05665,-0.0498084),origin=(1,0))

g.yaxislabel.text='log$_10$.(|$~W$_z$.|)'
g.title.off()

g.world.y=[-6,4]

