#! /usr/bin/env python

from __future__ import print_function
import sys

# If your pyfplo is not found you could also
# explicitly specify the pyfplo version path:
#sys.path.insert(0,"/home/magru/FPLO/FPLO22.00-62/PYTHON/doc");

import numpy as np
import pyfplo.slabify as sla


print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(sla.version,sla.__file__))
# protect against wrong version
#if fedit.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')


# ===================================================================
# 
# ===================================================================

def work():



    hamdata='../+hamdata'

    s=sla.Slabify()
    s.object='semislab'
    s.zaxis=[0,1,0]
    s.numberoflayers=2
    s.printStructureSettings()
    s.prepare(hamdata)


    bp=sla.BandPlot()
    bp.ndiv=100
    bp.points=[
        ['X',[0.5,0,0]],
        ['$~G',[0,0,0]],
        ['X',[0.5,0,0]],
    ]
    bp.calculateBandPlotMesh(s.dirname)
    ec=sla.EnergyContour(400,-6,6)
    s.calculateEDC(bp,ec,penetrationdepth=-1,suffix='_1block')


    # another zoom
    s.dirname='zoom'
    bp.points=[
        ['X $arrowleft',[0.15,0,0]],
        ['$~G',[0,0,0]],
        ['$arrowright X',[0.15,0,0]],
    ]
    bp.calculateBandPlotMesh(s.dirname)

    ec=sla.EnergyContour(200,-0.5,0.5)
    s.calculateEDC(bp,ec,penetrationdepth=-1,suffix='_1block')

# ===================================================================
# 
# ===================================================================


if __name__ == '__main__':

    work()

