#! /usr/bin/env python
from __future__ import print_function
import sys,copy
import numpy as np
import pyfplo.slabify as sla
import pyfplo.common as com
import pyfplo.fploio as fploio








# ===================================================================
# 
# ===================================================================
def work():

    print( '\nversion: ',sla.version,'\n')

    np.set_printoptions(precision=5,suppress=True,linewidth=120)
    
    hamdata='../../+hamdata'


    s=sla.Slabify()
    s.object='3d'
    s.printStructureSettings()
    s.prepare(hamdata)


    p=fploio.INParser()
    p.parseFile('../../=.in')
    d=p()('special_sympoints')
    l=[]
    for i in range(d.size()):
        l.append([ d[i]('label').S,d[i]('kpoint').listD])

    bp=com.BandPlot()
    bp.points=l
    bp.ndiv=100
    bp.calculateBandPlotMesh(s.dirname)

    #help(sla)
    s.calculateBandStructure(bp)

    # 14 -> 0;(000) 
    # 16 -> 1;(111)
    # 18 -> 1;(000)
    # 20 -> 0;(000)
    # 22 -> 1;(111)
    # 24 -> 0;(000)

    s.calculate3dTIInvariants(200,200,homos=range(14,25,2),efhomo=18)

        


                
    return

# ===================================================================
# 
# ===================================================================


if __name__ == '__main__':

    work()

    
