#! /usr/bin/env python
from __future__ import print_function
import pyfplo.wanniertools as wt


# ===================================================================

if __name__ == '__main__':


    wdc=wt.WanDefCreator(rcutoff=30,wftol=0.001,coeffformat='bin',
                         wfgriddirections=[[2,0,0],[0,2,0],[0,0,2]],
                         wfgridsubdiv=[1,1,1],savespininfo=True)


    emin=-15
    emax=6
    delower=1
    deupper=0.1
    lbands=101
    ubands=130
    wdc.add(wt.MultipleOrbitalWandef('Bi',[1,2],['6pb'],
                                     emin=emin,emax=emax,
                                     lbands=lbands,ubands=ubands,
                                     delower=delower,deupper=deupper))
    wdc.add(wt.MultipleOrbitalWandef('Se',[3,4,5],['4pb'],
                                     emin=emin,emax=emax,
                                     lbands=lbands,ubands=ubands,
                                     delower=delower,deupper=deupper))

    wdc.writeFile('=.wandef')

    

