#! /usr/bin/env python3
# ===================================================================
# file:   g.py
# author: k.koepernik@ifw-dresden.de
# date:   22 Jun 2022

from __future__ import print_function
import sys
import numpy as np
import pyfplo.fploio as fploio

print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(fploio.version,fploio.__file__))
# protect against wrong version
#if fploio.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')


# ===================================================================
# 
# ===================================================================
def work(printmodes=True):

    if printmodes: # print grep modes
        for k in fploio.OutGrep.modes.keys():
            print('mode: {0:15s} : {1}'.format(k,fploio.OutGrep.modes[k]))
        print('-'*72,'\n')

    # this will read the file
    og=fploio.OutGrep('out')
    si=og.sites()

    # grep some results from last appearance in file (last iteration)
    results={}
    results['etot']      = float(og.grep('EE')[-1])
    results['total spin']= float(og.grep('SS')[-1])

    for i,s in enumerate(si):
        site=i+1
        results['spin {0}{1:<3d}'.format(s.element,site)]\
            =float(og.grep('SSat',site)[-1])

    
    for k in results.keys():
        print('{0:<20s} {1:>20.10f}'.format(k,results[k]))

    
    if printmodes: print('\n','-'*72)
    
    return

# ===================================================================
# 
# ===================================================================

if __name__ == '__main__':

    work()
    
    sys.exit(0)

