#! /usr/bin/env python
# ===================================================================
# file:   bandplot.py
# author: k.koepernik@ifw-dresden.de
# date:   19 Apr 2017
from __future__ import print_function
import sys,os
import pyfplo.fploio as fploio
# ===================================================================
# 
# ===================================================================
def work():


    print( '\nThis fictitious example shows simple mid level =.in writing.')
    print( 'DO NOT DO THIS UNLESS YOU ARE CONFIDENT YOUR DOING THE '+
        'RIGHT THING.\n')
    
    fio=fploio.FPLOInput()
    if os.path.exists('=.in'):
        fio.parseInFile(True)
    else:
        fio.createNewFileContent()
        
    p=fio.parser()
    d=p() # the root of the data tree


    # set length units
    d("lengthunit.type").L=2
    # not really needed but good for human readers of =.in
    d("lengthunit.description").S='angstroem'

    
    # set wyckoff positions
    d("nsort").L=3
    # yes, we need to do this too.
    dw=d("wyckoff_positions")
    dw.resize(3)

    i=0 ;
    di=dw[i]
    di('element').S='Fe'
    di('tau').listD=[0,0,0]
    
    i+=1 ; di=dw[i]
    di('element').S='Al'
    di('tau').listS=['1/2','1/2','1/2']

    i+=1 ; di=dw[i]
    di('element').S='Mn'
    di('tau').listS=['1/4','1/4','1/4']

    d('lattice_constants').listD=[5.4,5.4,5.4]
    #or 
    d('lattice_constants').listS=['5.4','5.4','5.4']
    
    # symmetry update required
    msg=fio.symmetryUpdate();
    print( msg)

    # reset all other input, to get a default file
    fio.resetNonSymmetrySections()

    # here we can set other things
    d('spin.mspin').L=2

    fio.writeFile("=.in")

    print( 'done')
    
    
    return

# ===================================================================
# 
# ===================================================================

if __name__ == '__main__':

    work()
    
    sys.exit(0)




