#! /usr/bin/env python
# ===================================================================
# file:   basis.py
# author: k.koepernik@ifw-dresden.de
# date:   06 Jun 2017
from __future__ import print_function
import sys
import os
import pyfplo.fedit as fedit
import pyfplo.fploio as fploio

print( '\npyfplo version=: {0}\nfrom: {1}\n'.format(fedit.version,fedit.__file__))
# protect against wrong version
#if fedit.version!='22.00': raise RuntimeError('pyfplo version is incorrect.')

# ===================================================================
# 
# ===================================================================
def work_short_version(prot=True):

   
    if not os.path.exists('=.in'):
        print('ERROR: this script assumes the existence of an =.in-file.')
        sys.exit(1)


    p=fploio.INParser()
    p.parseFile('=.in')
    d=p()('wyckoff_positions')
    elements=[d[i]('element').S for i in range(d.size())]
    bastype=p()('basis.version.type').L
    b=fploio.Basis(bastype,elements)
    b.writeFile()

    os.system('ls -ltr ; echo ; cat =.basdef')
    
    return

# ===================================================================
# 
# ===================================================================
def work_long_version(prot=True):

    if not os.path.exists('=.in'):
        print('ERROR: this script assumes the existence of an =.in-file.')
        sys.exit(1)


    # 1: Get info for hand-made basis creation

    # Read =.in to get basisversion (optional) and
    # element (optionally: atomic number) list
    p=fploio.INParser()
    p.parseFile('=.in')
    d=p()('wyckoff_positions')
    elements=[d[i]('element').S for i in range(d.size())]
    atomicnumbers=list(map(lambda x: fploio.c_elements.index(x),elements))
    if prot:
        print(('\n=.in contains Wyckoff positions with\n\telements        '
               +'{}\n\tatomic numbers  {}\n')
              .format(elements,atomicnumbers))
    basversion=(p()('basis.version.type').L,p()('basis.version.description').S)


    print('basis version in =.in: key={0[0]} name="{0[1]}"\n'.format(basversion))
    print('available versions:\n',fploio.Basis.versions,'\n')

    # 2: Get default basis, compatible with =.in-content.
    #    We could use basversion[0], or basversion[1] as argument
    #    to fploio.Basis or (in later fplo versions) another basis ID.
    b=fploio.Basis('default FPLO9 basis',elements)
    # eqiuvalent:
    # b=fploio.Basis(1,elements)
    # or like this:
    # b=fploio.Basis('default FPLO9 basis',atomicnumbers)

    # 3: write basdeffile (=.basdef):
    b.writeFile()
    #or 
    #b.writeFile('=.basdef')

    # Now we have the default basis in '=.basdef' which would be used by fplo
    # on running.  We could modify it by hand too.

    os.system('ls -ltr ; echo ; cat =.basdef')
    
    return

# ===================================================================
# 
# ===================================================================

if __name__ == '__main__':

    print('-'*72,'\nlong version\n','-'*72)
    work_long_version()

    print('-'*72,'\nshort version\n','-'*72)
    work_short_version()
    
    sys.exit(0)




