from math import  *
killall()
# setup graph/group
g=G[1]
gr=g.Gr[1]

# make a set
s=gr.S[1].on()
N=1000
s.x=Vector(N,0,10)
s.y=list(map(sin,s.x)) # use math.sin on vectors/lists
s.line.color=0xff
s.legend='sin'

# copy onto set 2 and modify
gr.S[2]=s
s2=gr.S[2]
s2.y=list(map(cos,s.x))
s2.line.color=0xff0000  
s2.legend='cos'

#first derivative  
gr.S[3]=s
ds=gr.S[3]
ds.bspline(2,1)

#difference  
ds.y-=s2.y  
ds.y*=10**5
ds.line.color=0xff00  
ds.legend="d/dx sin(x) - cos(x): error*10$^5$."  
g.world.offset=(0.05,0.05)
g.autoscale ()

g.title.text='B-spline derivative example'
g.xaxislabel.text='x'
g.yaxislabel.text='y'


g.legend.linespacing=-0.2
g.legend.font.size=10
g.legend.frame.borderspacing=0.5

arrange(paperwidth=500,Nx=1,leftgap=0.15,rightgap=0.05,
    hgap=0.1,Ny=1,topgap=0.166,bottomgap=0.19,vgap=0.1,
    aspectratio=1.48292, commonxaxis=True,commonyaxis=True,
    commontitle=True)


