# -- mode: PYTHON --
import numpy as np

#============================================================

def f(x,y):
    return np.cos(x)+np.cos(x*(x**2+y**2))

#============================================================

killall()

# make a new densplot
g=G[1]
gr=g.Gr[1].on()
s=gr.S[1].on()
s.type='xynz' # set the data type

Nx=200
Ny=100
# set the x and y values from numpy arrays/Vector (to show what;s possible)
s.x=np.linspace(-np.pi*3,np.pi*3,Nx)
s.y=Vector(Ny,-np.pi*3,np.pi*3) # Ny is in first place to allow
                                # Vector(10) -> zero filled


# construct a flat numpy array containing z(x,y)
# x runs first
w=np.array([f(x,y) for x in s.x for y in s.y ])

# assign in bulk: [w] is one z-component/z(x,y) 
#  [w1,w2] would be two z-components/z(x,y)
s.z=[w]



# or set the number of components
s.z.len=1
# and assign single component
s.z[0]=w



# or set the number of components
s.z.len=1
# and assign each data point separately
for i,xx in enumerate(s.x):
    for j,yy in enumerate(s.y):
        s.z[0,i,j]=f(xx,yy)

# which component to plot
s.zcomponent=0
# setup some default scalemax, z0
s.adjustDensPlot()
# not good enough
s.z0=-2
# pick colormap
s.colormap='inferno'

# make it smoother
s.interpolationdepth=2

#and
g.autoscale()

g.title.text='Illusion' 
g.title.restriction=("y",0)
g.subtitle.on().text='The circles are Moire patterns' 
g.xaxislabel.off()
g.yaxislabel.off()
g.legend.off()

arrange(paperwidth=600,Nx=1,leftgap=0.1,rightgap=0.05,
    hgap=0.1,Ny=1,topgap=0.166,bottomgap=0.1,vgap=0.1,
    aspectratio=1.48292, commonxaxis=True,commonyaxis=True,
    commontitle=True)

printto('illusion.png')