# -- mode: PYTHON --
import numpy as np

killall()

gr=G[1].Gr[1].on()

N=100
x0=0.
x1=np.pi

for id in [1,2,3]: # 3 sets
    s=gr.S[id].on()
    s.x=np.linspace(x0,x1,N)
    s.y=np.cos(s.x*id)
    # set weight plot type
    s.type='xynw'
    # three weights
    s.z.len=3 # this is important to set up internal weightlabels


    # set at once
    s.z=[3*s.x,2*s.x,1*s.x] # assign list of three weight vectors


    # or
    w=np.array([3*s.x,2*s.x,1*s.x]) # we got some numpy array
    s.z=w # and assign it


    # or via indices
    for i in range(N):
        s.z[0,i]=3*np.abs(s.x[i]) # weight 1
        s.z[1,i]=2*np.abs(s.x[i]) # weight 2
        s.z[2,i]=1*np.abs(s.x[i]) # weight 3


# now unify the weight labels 
gr.unifyWeightLabels()
# use the group to set properties
gr.useattributes=1
# set the Weights style
gr.setWeightsStyle(style='connected',factor=1,min=0.2,max=6,
                   showinlegend=True)

# switch all on
for w in gr.W:  w.on()

# some colors
gr.W[1].color=0xaa00
gr.W[2].color=0xff00ff
gr.W[3].color=0xffff00


G[1].autoscale()