import numpy as np
killall()
g=G[1].on()

Ga=1
wp=3
N=1000
x0=1e-1
x1=10
m=Vector(N,x0,x1)
s=g.Gr[1].S[1].on()
s.x=m
s.y=1-wp**2/((s.x**2+Ga**2))
g.Gr[1].S[2]=g.Gr[1].S[1]
s2=g.Gr[1].S[2]
s2.y=wp**2*Ga/(s.x*(s.x**2+Ga**2))
s.legend="Re $~e"
s2.legend="Im $~e"
s2.line.color=0xff0000


g.title.text="intra band contribution ($~G=1eV)"
g.xaxislabel.text="Energy [eV]"
g.yaxislabel.text="$~e"

g.Gr[1].S[4]=g.Gr[1].S[1]
s4=g.Gr[1].S[4]
s4.y=wp**2*Ga/(s4.x**2+Ga**2)/4/np.pi
s4.legend="Re $~s"
s4.line.color=0xaa00

g.Gr[1].S[5]=g.Gr[1].S[1]
s5=g.Gr[1].S[5]

s5.y=s5.x*Ga*wp**2/((s5.x**2-wp**2)**2+s5.x**2*Ga**2)
s5.line.color=0xff
s5.legend="L"


#group irregular tics
G[1].Gr[1].usertics.on().clear()\
  .append(Tic(type='xmajor',position=np.sqrt(wp**2-Ga**2),label='',
          ticside='Normal',labelside='Normal',length=1,labeloffset=0.03,
          line=LineStyle(style='dash',width=1,color=0x0,extracolor=True)))\
  .append(Tic(type='ymajor',position=0,label='',
          ticside='Normal',labelside='Normal',length=1,labeloffset=0.03,
          line=LineStyle(style='dash',width=1,color=0x0,extracolor=True)))\
  .append(Tic(type='xmajor',position=wp*(1-Ga**2/wp**2/8),label='',
          ticside='Normal',labelside='Normal',length=1,labeloffset=0.03,
          line=LineStyle(style='dash',width=1,color=0x0,extracolor=True)))

Line(1,1).on().setName('')\
 .setGeometry(startat=(1.95076,-3.22678),endat=(2.7395,-0.287448),system='World')\
 .setLine(capat='None',style=LineStyle(style='solid',width=1,color=0x0,extracolor=True))\
 .setArrow(at='End',style='Closed',size=16,sharpness=2,
  fill=FillStyle(active=0,color=0x0,extracolor=True))

Line(1,2).on().setName('')\
 .setGeometry(startat=(4.40637,-3.27366),endat=(3.03492,-0.351257),system='World')\
 .setLine(capat='None',style=LineStyle(style='solid',width=1,color=0x0,extracolor=True))\
 .setArrow(at='End',style='Closed',size=16,sharpness=2,
  fill=FillStyle(active=0,color=0x0,extracolor=True))

TextBox(1,1).on()\
  .setText("sqrt($~w$_p$.$^2$.-$~G$^2$.)",
    font=FontStyle(size=16,subscriptscale=0.75,color=0x0))\
  .setFrame(Frame(active=0,borderspacing=0.2,
    rim=LineStyle(style='solid',width=1,color=0x0,extracolor=True),
    fill=FillStyle(active=True,color=0xffffff,extracolor=True)))\
  .setGeometry(system='World',position=(1.98016 , -3.1991),angle=0,
    origin=(0.5,0),  restriction=None,offsets=[])

TextBox(1,2).on()\
  .setText("$~w$_p$.(1-$~(G/$~w$_p$.)$^2$./8)",
    font=FontStyle(size=16,subscriptscale=0.75,color=0x0))\
  .setFrame(Frame(active=0,borderspacing=0.2,
    rim=LineStyle(style='solid',width=1,color=0x0,extracolor=True),
    fill=FillStyle(active=True,color=0xffffff,extracolor=True)))\
  .setGeometry(system='World',position=(4.49426 , -3.19064),angle=0,
    origin=(0.5,0),  restriction=None,offsets=[])



g.autoscale()
g.world.y=[ -5,5]



printto("intra.png")